/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.common.util.PIHscUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

class SetMh {
    static String CEC_CIM_CLASS = "IBMHSC_ComputerSystem";
    static String CREATION_CLASS_NAME = "CreationClassName";
    static Vector inParams;
    static Vector outParams;

    SetMh() {
    }

    static String getHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    static CIMObjectPath getCOP(String string) {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(CEC_CIM_CLASS, "root/ibmhscS1_0");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string));
        cIMObjectPath.addKey(CREATION_CLASS_NAME, new CIMValue((Object)CEC_CIM_CLASS));
        return cIMObjectPath;
    }

    static Vector getIOHubs(String string) {
        Object object;
        Vector vector = new Vector();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(SetMh.getHostName(), SetMh.getCOP(string), "GetIOHubs", vector, vector2);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetIOHubs method.");
            exception.printStackTrace();
            System.exit(5);
        }
        vector2.add(new CIMProperty("DRCIndex", new CIMValue(new Vector(), new CIMDataType(25))));
        vector2.add(new CIMProperty("HubType", new CIMValue(new Vector(), new CIMDataType(21))));
        object = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector4.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt32 = null;
        int n = -1;
        int n2 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
            unsignedInt32 = (UnsignedInt32)enumeration2.nextElement();
            n = unsignedInt8.intValue();
            n2 = unsignedInt32.intValue();
            if (n == 0) {
                vector3.add(unsignedInt32);
                continue;
            }
            if (n == 1) {
                System.out.println("HubType of Infiniband found on Managed System: " + string);
                System.out.println("Infiniband DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 2) {
                System.out.println("HubType of SMA found on Managed System: " + string);
                System.out.println("SMA DRCIndex value = " + n2);
                System.out.println("We do not need this HubType at the moment.");
                continue;
            }
            if (n == 255) {
                System.out.println("Error:BED1-0055:Unknown HubType on Managed System:" + string);
                System.exit(8);
                continue;
            }
            System.out.println("Error:BED1-0056:Unable to locate any I/O Hubs this system:" + string);
            System.exit(9);
        }
        return vector3;
    }

    static Vector getRioBuses(UnsignedInt32 unsignedInt32, String string, int n) {
        Object object;
        inParams = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32, new CIMDataType(5));
        inParams.add(new CIMProperty("HubDRCIndex", cIMValue));
        outParams = new Vector();
        Vector<UnsignedInt32> vector = new Vector<UnsignedInt32>();
        try {
            object = PIHscUtil.invokeCIMMethod(SetMh.getHostName(), SetMh.getCOP(string), "GetRioBuses", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioBuses method.");
            exception.printStackTrace();
            System.exit(6);
        }
        object = (Vector)((CIMProperty)outParams.elementAt(0)).getValue().getValue();
        Vector vector2 = (Vector)((CIMProperty)outParams.elementAt(1)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector2.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt32 unsignedInt322 = null;
        int n2 = -1;
        int n3 = -1;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            unsignedInt8 = (UnsignedInt8)enumeration2.nextElement();
            unsignedInt322 = (UnsignedInt32)enumeration.nextElement();
            n2 = unsignedInt8.intValue();
            n3 = unsignedInt322.intValue();
            if (n2 == 0) continue;
            if (n2 == 1) {
                vector.add(unsignedInt322);
                continue;
            }
            System.out.println("Unknown Bus Type");
            System.exit(10);
        }
        return vector;
    }

    static Vector getRioNodes(UnsignedInt32 unsignedInt32, String string) {
        Object object;
        inParams = new Vector();
        outParams = new Vector();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt32);
        inParams.add(new CIMProperty("BusNumber", cIMValue));
        try {
            object = PIHscUtil.invokeCIMMethod(SetMh.getHostName(), SetMh.getCOP(string), "GetRioTopology", inParams, outParams);
        }
        catch (Exception exception) {
            System.out.println("Could not invoke GetRioNodes(RioTopology) method.");
            exception.printStackTrace();
            System.exit(7);
        }
        object = (Vector)((CIMProperty)outParams.elementAt(2)).getValue().getValue();
        Vector vector3 = (Vector)((CIMProperty)outParams.elementAt(3)).getValue().getValue();
        Vector vector4 = (Vector)((CIMProperty)outParams.elementAt(21)).getValue().getValue();
        Vector vector5 = (Vector)((CIMProperty)outParams.elementAt(8)).getValue().getValue();
        Vector vector6 = (Vector)((CIMProperty)outParams.elementAt(10)).getValue().getValue();
        Vector vector7 = (Vector)((CIMProperty)outParams.elementAt(12)).getValue().getValue();
        Vector vector8 = (Vector)((CIMProperty)outParams.elementAt(15)).getValue().getValue();
        Vector vector9 = (Vector)((CIMProperty)outParams.elementAt(18)).getValue().getValue();
        Enumeration enumeration = ((Vector)object).elements();
        Enumeration enumeration2 = vector3.elements();
        Enumeration enumeration3 = vector4.elements();
        Enumeration enumeration4 = vector5.elements();
        Enumeration enumeration5 = vector6.elements();
        Enumeration enumeration6 = vector7.elements();
        Enumeration enumeration7 = vector8.elements();
        Enumeration enumeration8 = vector9.elements();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt8 unsignedInt82 = null;
        UnsignedInt8 unsignedInt83 = null;
        UnsignedInt8 unsignedInt84 = null;
        UnsignedInt32 unsignedInt322 = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Date date = new Date();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("/var/esshmc/log/rsMMAutoSetMhJava.log", true));
            bufferedWriter.write("START: Get values to set multihub==========> " + date.toString() + "\n");
            while (enumeration.hasMoreElements() && enumeration2.hasMoreElements() && enumeration3.hasMoreElements() && enumeration4.hasMoreElements() && enumeration5.hasMoreElements() && enumeration6.hasMoreElements()) {
                unsignedInt8 = (UnsignedInt8)enumeration.nextElement();
                unsignedInt82 = (UnsignedInt8)enumeration2.nextElement();
                unsignedInt83 = (UnsignedInt8)enumeration7.nextElement();
                unsignedInt84 = (UnsignedInt8)enumeration8.nextElement();
                unsignedInt322 = (UnsignedInt32)enumeration4.nextElement();
                string2 = (String)enumeration3.nextElement();
                string3 = (String)enumeration5.nextElement();
                string4 = (String)enumeration6.nextElement();
                int n = unsignedInt8.intValue();
                int n2 = unsignedInt82.intValue();
                int n3 = unsignedInt322.intValue();
                int n4 = unsignedInt83.intValue();
                int n5 = unsignedInt84.intValue();
                if (string2 != null && string2.startsWith("UTMP")) {
                    System.out.println("Enclosure Location Code is " + string2);
                    bufferedWriter.write("Enclosure Location Code is " + string2 + "\n");
                    System.out.println("Error:VPD is either NOT written or is corrupted on this system. The node is on bus number " + unsignedInt32 + ". (RC=3)");
                    bufferedWriter.write("Error:VPD is either NOT written or is corrupted on this system. The node is on bus number " + unsignedInt32 + ". (RC=3)" + "\n");
                    System.exit(3);
                }
                if (n == 1 && n2 == 0 && n4 == 1 && n5 == 1) {
                    System.out.println("LeadingPortStatus = FAILED");
                    bufferedWriter.write("LeadingPortStatus = FAILED\n");
                    System.out.println("TrailingPortStatus = FAILED");
                    bufferedWriter.write("TrailingPortStatus = FAILED\n");
                    System.out.println("Error: A Leading and Trailing Port failure has been detected on the Local NIC on Bus Number " + unsignedInt32 + ". Unable to determine if there are any MM I/O Towers on this system.(RC=2)");
                    bufferedWriter.write("Error: A Leading and Trailing Port failure has been detected on the Local NIC on Bus Number " + unsignedInt32 + ". Unable to determine if there are any MM I/O Towers on this system.(RC=2)" + "\n");
                    System.exit(2);
                }
                if ((string2 != null && string2.startsWith("U7311.D11") || string2 != null && string2.startsWith("U1300.001")) && n == 0 && n2 == 128) {
                    System.out.println("The locally owned MM I/O Tower(s) are already set to Multihub on RIO bus number " + unsignedInt32 + ".");
                    bufferedWriter.write("The locally owned MM I/O Tower(s) are already set to Multihub on RIO bus number " + unsignedInt32 + "." + "\n");
                    System.out.println("***************MultiHub****************");
                    bufferedWriter.write("***************MultiHub****************\n");
                    System.out.println("NodeType = " + object);
                    bufferedWriter.write("NodeType = " + object + "\n");
                    System.out.println("NodeFlag = " + vector3);
                    bufferedWriter.write("NodeFlag = " + vector3 + "\n");
                    System.out.println("***************MultiHub****************");
                    bufferedWriter.write("***************MultiHub****************\n");
                    System.out.println("\n");
                    bufferedWriter.write("\n");
                }
                if ((string2 == null || !string2.startsWith("U7311.D11")) && (string2 == null || !string2.startsWith("U1300.001")) || n != 0 || n2 != 0) continue;
                System.out.println("******* BUS NUMBER ******* = " + unsignedInt32);
                bufferedWriter.write("******* BUS NUMBER ******* = " + unsignedInt32 + "\n");
                System.out.println("nodeTypeVector =   " + object);
                bufferedWriter.write("nodeTypeVector =   " + object + "\n");
                System.out.println("NodeType = " + n);
                bufferedWriter.write("NodeType = " + n + "\n");
                System.out.println("nodeFlagVector =   " + vector3);
                bufferedWriter.write("nodeFlagVector =   " + vector3 + "\n");
                System.out.println("NodeFlag = " + n2);
                bufferedWriter.write("NodeFlag = " + n2 + "\n");
                System.out.println("encLocCodeVec  =   " + vector4);
                bufferedWriter.write("encLocCodeVec  =   " + vector4 + "\n");
                System.out.println("Enclosure Location Code = " + string2);
                bufferedWriter.write("Enclosure Location Code = " + string2 + "\n");
                System.out.println("drcIndexVector =  " + vector5);
                bufferedWriter.write("drcIndexVector =  " + vector5 + "\n");
                System.out.println("DRCIndex to pass to SetMultiHub Mode = " + n3);
                bufferedWriter.write("DRCIndex to pass to SetMultiHub Mode = " + n3 + "\n");
                short s = 1;
                UnsignedInt8 unsignedInt85 = new UnsignedInt8(s);
                System.out.println("Calling set MultiHubMode Method with the following:" + string + " " + n3 + " " + unsignedInt85);
                bufferedWriter.write("Calling set MultiHubMode Method with the following:" + string + " " + n3 + " " + unsignedInt85 + "\n");
                int n6 = SetMh.setMultiHubMode(string, unsignedInt322, unsignedInt85);
            }
            bufferedWriter.write("END:Get values to set mulithub==========> " + date.toString() + "\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for logging.");
            iOException.printStackTrace();
        }
        return vector;
    }

    static int setMultiHubMode(String string, UnsignedInt32 unsignedInt32, UnsignedInt8 unsignedInt8) {
        Date date = new Date();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("/var/esshmc/log/rsMMAutoSetMhJava.log", true));
            System.out.println("Setting MultiHubMode() : ");
            bufferedWriter.write("Setting MultiHubMode() : \n");
            inParams = new Vector();
            System.out.println("\n");
            bufferedWriter.write("\n");
            CIMValue cIMValue = new CIMValue((Object)unsignedInt32);
            CIMValue cIMValue2 = new CIMValue((Object)unsignedInt8);
            inParams.add(new CIMProperty("DRCIndex", cIMValue));
            inParams.add(new CIMProperty("modeSet", cIMValue2));
            System.out.println("\n\n The size is: " + inParams.size());
            bufferedWriter.write("\n\n The size is: " + inParams.size() + "\n");
            System.out.println(inParams);
            outParams = new Vector();
            try {
                CIMValue cIMValue3 = PIHscUtil.invokeCIMMethod(SetMh.getHostName(), SetMh.getCOP(string), "SetMultiHubMode", inParams, outParams);
            }
            catch (Exception exception) {
                System.out.println("Could not invoke setMultiHub method.");
                exception.printStackTrace();
                System.exit(13);
            }
            System.out.println("The setMultiHub results are: " + outParams);
            bufferedWriter.write("The setMultiHub results are: " + outParams + "\n");
            bufferedWriter.write("END:Setting Multihub Bit==========> " + date.toString() + "\n");
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not open file for logging.");
            iOException.printStackTrace();
        }
        return 0;
    }
}

